% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NUpE.R
\name{NUpE}
\alias{NUpE}
\title{Calculate N Uptake Efficiency (NUpE)}
\usage{
NUpE(PlantN, SoilN, FertN)
}
\arguments{
\item{PlantN}{A numeric vector of values for plant N content.}

\item{SoilN}{A numeric value or vector for soil N content.}

\item{FertN}{A numeric value or vector for fertilizer N input.}
}
\value{
A numeric vector of NUpE percentages.
}
\description{
The percentage of available soil N that is utilized by the plant.
Formula: NUpE = (PlantN / (FertN + SoilN)) * 100
}
\examples{
PlantN <- c(3.0, 3.5, 3.8)
SoilN <- c(20, 20, 20)
FertN <- 50
NUpE(PlantN, SoilN, FertN)
}
