\name{conductors}
\alias{conductors}
\docType{data}

\title{Electromigration Failure Times of Microcircuit Conductors}

\description{
Failure-time data from an accelerated life test involving 59 microcircuit
conductors. Electromigration refers to the movement of atoms in conductors under
high current density, leading to eventual failure. The dataset contains
observed failure times (in hours), with no censored observations.
}

\usage{
data(conductors)
}

\format{
A numeric vector of length 59 giving failure times in hours.
}

\value{
An object of class \code{"numeric"}.

The vector consists of 59 observed failure times (in hours), each corresponding
to a single microcircuit conductor subjected to an accelerated life test.
Each value represents the elapsed operating time until failure caused by
electromigration. The dataset is commonly used in reliability engineering and
lifetime data analysis to illustrate wear-out mechanisms and to fit and compare
parametric lifetime models such as the Weibull, lognormal, and power-lognormal
distributions.
}

\details{
Electromigration is a major wear-out mechanism in thin-film microelectronic
circuits. Because electric current accelerates atomic migration, accelerated
life tests are widely used to study the reliability of conductors. This dataset
has been used extensively in the reliability literature, including analyses
involving Weibull, lognormal, and power-lognormal lifetime models.
}

\references{
Lawless, J. F. (2003).
\emph{Statistical Models and Methods for Lifetime Data}.
John Wiley & Sons.

Nelson, W., & Doganaksoy, N. (1995). Statistical analysis of life or strength
data from specimens of various sizes using the power-(log)normal model.
\emph{Recent Advances in Life-Testing and Reliability}, 377--408.
}

\examples{
data(conductors)

# Summary statistics
summary(conductors)

# Histogram of failure times
hist(conductors)
}

\keyword{datasets}
