% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CharacterzationQueries.R
\name{getTargetContinuousFeatures}
\alias{getTargetContinuousFeatures}
\title{Extract aggregate statistics of continuous feature analysis IDs of interest for targets}
\usage{
getTargetContinuousFeatures(
  connectionHandler,
  schema,
  cTablePrefix = "c_",
  cgTablePrefix = "cg_",
  databaseTable = "database_meta_data",
  targetIds = NULL,
  analysisIds = NULL,
  databaseIds = NULL
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{cTablePrefix}{The prefix used for the characterization results tables}

\item{cgTablePrefix}{The prefix used for the cohort generator results tables}

\item{databaseTable}{The name of the table with the database details (default 'database_meta_data')}

\item{targetIds}{A vector of integers corresponding to the target cohort IDs}

\item{analysisIds}{The feature extraction analysis ID of interest (e.g., 201 is condition)}

\item{databaseIds}{(Optional) A vector of database IDs to restrict to}
}
\value{
Returns a data.frame with the columns:
\itemize{
 \item{databaseName the name of the database}
 \item{databaseId the unique identifier of the database}
 \item{targetName the target cohort name}
 \item{targetId the target cohort unique identifier}
 \item{minPriorObservation the minimum required observation days prior to index for an entry}
 \item{covariateName the name of the feature}
 \item{covariateId the id of the feature}
 \item{countValue the number of cases who have the feature}
 \item{minValue the minimum value observed for the feature}
 \item{maxValue the maximum value observed for the feature}
 \item{averageValue the mean value observed for the feature}
 \item{standardDeviation the standard deviation of the value observed for the feature}
 \item{medianValue the median value observed for the feature}
 \item{p10Value the 10th percentile of the value observed for the feature}
 \item{p25Value the 25th percentile of the value observed for the feature}
 \item{p75Value the 75th percentile of the value observed for the feature}
 \item{p90Value the 90th percentile of the value observed for the feature}
 
}
}
\description{
This function extracts the continuous feature extraction results for targets corresponding to specified target cohorts.
}
\details{
Specify the connectionHandler, the schema and the target/outcome cohort IDs
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

tcf <- getTargetContinuousFeatures(
connectionHandler = connectionHandler, 
schema = 'main'
)

}
\seealso{
Other Characterization: 
\code{\link{getBinaryCaseSeries}()},
\code{\link{getBinaryRiskFactors}()},
\code{\link{getCaseBinaryFeatures}()},
\code{\link{getCaseContinuousFeatures}()},
\code{\link{getCaseCounts}()},
\code{\link{getCaseTargetBinaryFeatures}()},
\code{\link{getCaseTargetCounts}()},
\code{\link{getCharacterizationCohortBinary}()},
\code{\link{getCharacterizationCohortContinuous}()},
\code{\link{getCharacterizationDemographics}()},
\code{\link{getCharacterizationOutcomes}()},
\code{\link{getCharacterizationTargets}()},
\code{\link{getContinuousCaseSeries}()},
\code{\link{getContinuousRiskFactors}()},
\code{\link{getDechallengeRechallenge}()},
\code{\link{getDechallengeRechallengeFails}()},
\code{\link{getIncidenceOutcomes}()},
\code{\link{getIncidenceRates}()},
\code{\link{getIncidenceTargets}()},
\code{\link{getTargetBinaryFeatures}()},
\code{\link{getTimeToEvent}()},
\code{\link{plotAgeDistributions}()},
\code{\link{plotSexDistributions}()}
}
\concept{Characterization}
