% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildObservationPeriod.R
\name{buildObservationPeriod}
\alias{buildObservationPeriod}
\title{Build \code{observation_period} table from data recorded in the \code{cdm_reference}}
\usage{
buildObservationPeriod(
  cdm,
  collapseDays = Inf,
  persistenceDays = Inf,
  dateRange = as.Date(c("1900-01-01", NA)),
  censorAge = 120L,
  recordsFrom = c("drug_exposure", "visit_occurrence"),
  periodTypeConceptId = 32817L
)
}
\arguments{
\item{cdm}{A \code{cdm_reference} object.}

\item{collapseDays}{Distance between records to be collapsed.}

\item{persistenceDays}{Number of days added at the end of an observation
period as persistence window.}

\item{dateRange}{Range of dates to be considered. By default '1900-01-01' is
used as start date, whereas for censor date the first available of
\code{source_release_date}, \code{cdm_release_date}, and \code{Sys.Date()} will be used.}

\item{censorAge}{Age to censor individuals if they reach a certain age.
The last day in observation of the individual will be the day prior to their
birthday.}

\item{recordsFrom}{Tables to retrieve observation records from.}

\item{periodTypeConceptId}{Choose the observation_period_type_concept_id that
best represents how the period was determined.
\href{https://athena.ohdsi.org/search-terms/terms?domain=Type+Concept&standardConcept=Standard&page=1&pageSize=15&query=}{Accepted Concepts}.}
}
\value{
The \code{cdm_reference} object with a new \code{observation_period}.
}
\description{
Build \code{observation_period} table from data recorded in the \code{cdm_reference}
}
