% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Graph_B_sets.R
\name{find_B_sets}
\alias{find_B_sets}
\alias{find_B_sets_v}
\title{Find all the B-sets of a given DAG}
\usage{
find_B_sets(DAG)

find_B_sets_v(DAG, v)
}
\arguments{
\item{DAG}{A bnlearn graph object}

\item{v}{node at which we want to find the B-sets}
}
\value{
\code{find_B_sets} returns a list with three elements \itemize{
   \item \code{B_sets} list of B-sets matrices for each node;

   \item \code{has_interfering_vstrucs} a boolean specifying if the graph
   contains interfering v-structures or not;

   \item \code{nodes_with_inter_vs} a list containing nodes forming the
   interfering v-structures.
}
\code{find_B_sets_v} returns a boolean matrix with \code{(2 + length(children))}
columns and \code{length(parents)} rows.
This is also true if \code{length(parents) == 0} and \code{length(parents) == 1}.
}
\description{
Find all the B-sets of a given DAG

Find the B sets for a given node v
}
\examples{
DAG = create_empty_DAG(6)
DAG = bnlearn::set.arc(DAG, 'U1', 'U5')
DAG = bnlearn::set.arc(DAG, 'U2', 'U5')
DAG = bnlearn::set.arc(DAG, 'U3', 'U5')
DAG = bnlearn::set.arc(DAG, 'U4', 'U5')

DAG = bnlearn::set.arc(DAG, 'U1', 'U6')
DAG = bnlearn::set.arc(DAG, 'U2', 'U6')
DAG = bnlearn::set.arc(DAG, 'U5', 'U6')

find_B_sets_v(DAG, v = 'U5')
B_sets = find_B_sets(DAG)
B_sets$B_sets

}
