% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCBN-logLik.R
\name{logLik.PCBN}
\alias{logLik.PCBN}
\title{Log-likelihood of a PCBN object}
\usage{
\method{logLik}{PCBN}(object, data_uniform, ...)
}
\arguments{
\item{object}{the PCBN object}

\item{data_uniform}{the dataset for which the log-likelihood is computed.
It must have already been standardized to uniform margins.}

\item{...}{other arguments, ignored for the moment}
}
\value{
the log-likelihood of the PCBN model for the given dataset
}
\description{
This function computes the log-likelihood of the PCBN model given a dataset
of i.i.d. observations uniformly (or approximatively uniformly) distributed
on \eqn{[0,1]}. This is the same as the logarithm of the density of the PCBN
at the observations.
}
\examples{
DAG = create_empty_DAG(3)
DAG = bnlearn::set.arc(DAG, 'U1', 'U3')
DAG = bnlearn::set.arc(DAG, 'U2', 'U3')

order_hash = r2r::hashmap()
order_hash[['U3']] = c("U1", "U2")

fam = matrix(c(0, 0, 1,
               0, 0, 1,
               0, 0, 0), byrow = TRUE, ncol = 3)
tau = 0.2 * fam

my_PCBN = new_PCBN(
  DAG, order_hash,
  copula_mat = list(tau = tau, fam = fam))

mydata = PCBN_sim(my_PCBN, N = 10)

logLik(my_PCBN, mydata)

}
