% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test2SRE.R
\name{Test2SRE}
\alias{Test2SRE}
\title{Hypothesis testing for three null hypotheses}
\usage{
Test2SRE(data, effect = "DE", alpha = 0.05)
}
\arguments{
\item{data}{A data frame containing the relevant variables. The names for the variables should be ``Z'' for the treatment assignment, ``Y'' for the treatment outcome, ``A'' for the treatment assignment mechanism, and ``id'' for the cluster ID. The variable for the cluster ID should be a factor.}

\item{effect}{Specify which null hypothesis to be tested. ``DE'' for direct effect, ``ME'' for marginal effect, and ``SE'' for spillover effect.}

\item{alpha}{The level of significance at which the test is to be run (default is 0.05).}
}
\value{
A list of class \code{Test2SRE} which contains the following item:
\item{rej}{ Rejection region for test conducted. }
}
\description{
This function tests the null hypotheses of no direct effect, no marginal direct effect, and no spillover effect.
}
\details{
For the details of the method implemented by this function, see the
references.
}
\examples{
data(jd)
data_LTFC <- data.frame(jd$assigned, jd$pct0, jd$cdd6m, jd$anonale)
colnames(data_LTFC) <- c("Z", "A", "Y", "id")
Test2SRE(data_LTFC, effect="MDE", alpha=0.05)

}
\references{
Zhichao Jiang, Kosuke Imai (2020).
\dQuote{Statistical Inference and Power Analysis for Direct and Spillover Effects in Two-Stage Randomized Experiments}, \emph{Technical Report}.
}
\author{
Kosuke Imai, Department of Statistics, Harvard University
\email{imai@harvard.edu}, \url{https://imai.fas.harvard.edu/};
Zhichao Jiang, School of Public Health and Health Sciences, University of Massachusetts Amherst
\email{zhichaojiang@umass.edu};
Karissa Huang, Department of Statistics, Harvard College
\email{krhuang@college.harvard.edu}
}
\keyword{experiments}
\keyword{randomized}
\keyword{two-stage}
