% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMVL.R
\name{mvl_close}
\alias{mvl_close}
\title{Close MVL file}
\usage{
mvl_close(MVLHANDLE, checksums = FALSE)
}
\arguments{
\item{MVLHANDLE}{handle to opened MVL file as generated by mvl_open()}

\item{checksums}{set to true to compute and write checksums. Checksums are computing by rereading data in the MVL file which can increase I/O for temporary files. We recommend to always include checksums into final output files as file size increase is very small (1/8192 fraction).}
}
\value{
None
}
\description{
Closes MVL file releasing all resources.
For read-only files the memory is unmapped, reducing the virtual memory footprint.
For files opened for writing the directory is written out, so it is important to call \code{mvl_close} or the newly written file will be corrupt.
After \code{mvl_close()} all previously obtained MVL_OBJECT's with this handle become invalid.
}
\details{
When \code{checksums} is set to \code{TRUE} mvl_close() calls mvl_remap() and then computes and writes checksums. 
You can add checksums to MVL file by first calling mvl_open(filename, append=TRUE, create=FALSE) and then mvl_close(handle, checksums=TRUE).
}
\seealso{
\code{\link{mvl_open}}, \code{\link{mvl_remap}}
}
