% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbinom2.R
\name{nbinom2}
\alias{nbinom2}
\alias{dnbinom2}
\alias{pnbinom2}
\alias{qnbinom2}
\alias{rnbinom2}
\alias{pnbinom}
\title{Reparameterised negative binomial distribution}
\usage{
dnbinom2(x, mu, size, log = FALSE)

pnbinom2(q, mu, size, lower.tail = TRUE, log.p = FALSE)

qnbinom2(p, mu, size, lower.tail = TRUE, log.p = FALSE)

rnbinom2(n, mu, size)

pnbinom(q, size, prob, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{mu}{mean parameter, must be positive.}

\item{size}{size parameter, must be positive.}

\item{log, log.p}{logical; if \code{TRUE}, probabilities/ densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{lower.tail}{logical; if \code{TRUE}, probabilities are \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities}

\item{n}{number of random values to return.}

\item{prob}{probability of success in each trial. 0 < prob <= 1.}
}
\value{
\code{dnbinom2} gives the density, \code{pnbinom2} gives the distribution function, \code{qnbinom2} gives the quantile function, and \code{rnbinom2} generates random deviates.
}
\description{
Probability mass function, distribution function, quantile function, and random generation for
the negative binomial distribution reparameterised in terms of mean and size.
}
\details{
This implementation allows for automatic differentiation with \code{RTMB}.

\code{pnbinom} is an AD-compatible implementation of the standard parameterisation of the CDF, missing from \code{RTMB}.
}
\examples{
set.seed(123)
x <- rnbinom2(1, 1, 2)
d <- dnbinom2(x, 1, 2)
p <- pnbinom2(x, 1, 2)
q <- qnbinom2(p, 1, 2)
}
