% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pareto.R
\name{pareto}
\alias{pareto}
\alias{dpareto}
\alias{ppareto}
\alias{qpareto}
\alias{rpareto}
\title{Pareto distribution}
\usage{
dpareto(x, mu = 1, log = FALSE)

ppareto(q, mu = 1, lower.tail = TRUE, log.p = FALSE)

qpareto(p, mu = 1, lower.tail = TRUE, log.p = FALSE)

rpareto(n, mu = 1)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{mu}{location parameter, must be positive.}

\item{log, log.p}{logical; if \code{TRUE}, probabilities/ densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{lower.tail}{logical; if \code{TRUE} (default), probabilities are \eqn{P[X \le x]}, otherwise \eqn{P[X > x]}.}

\item{p}{vector of probabilities}

\item{n}{number of random values to return}
}
\value{
\code{dpareto} gives the density, \code{ppareto} gives the distribution function, \code{qpareto} gives the quantile function, and \code{rpareto} generates random deviates.
}
\description{
Density, distribution function, quantile function, and random generation for
the pareto distribution.
}
\details{
This implementation of \code{dpareto} and \code{ppareto} allows for automatic differentiation with \code{RTMB} while the other functions are imported from \code{gamlss.dist} package.
See \code{gamlss.dist::\link[gamlss.dist]{PARETO}} for more details.
}
\examples{
set.seed(123)
x <- rpareto(1, mu = 5)
d <- dpareto(x, mu = 5)
p <- ppareto(x, mu = 5)
q <- qpareto(p, mu = 5)
}
\references{
Rigby, R. A., Stasinopoulos, D. M., Heller, G. Z., and De Bastiani, F. (2019) Distributions for modeling location, scale, and shape: Using GAMLSS in R, Chapman and Hall/CRC,
doi:10.1201/9780429298547. An older version can be found in https://www.gamlss.com/.
}
