% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skewnorm.R
\name{skewnorm}
\alias{skewnorm}
\alias{dskewnorm}
\alias{pskewnorm}
\alias{qskewnorm}
\alias{rskewnorm}
\title{Skew normal distribution}
\usage{
dskewnorm(x, xi = 0, omega = 1, alpha = 0, log = FALSE)

pskewnorm(q, xi = 0, omega = 1, alpha = 0, ...)

qskewnorm(p, xi = 0, omega = 1, alpha = 0, ...)

rskewnorm(n, xi = 0, omega = 1, alpha = 0)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{xi}{location parameter}

\item{omega}{scale parameter, must be positive.}

\item{alpha}{skewness parameter, +/- \code{Inf} is allowed.}

\item{log}{logical; if \code{TRUE}, probabilities/ densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{...}{additional parameters to be passed to the \code{sn} package functions for \code{pskewnorm} and \code{qskewnorm}.}

\item{p}{vector of probabilities}

\item{n}{number of random values to return}
}
\value{
\code{dskewnorm} gives the density, \code{pskewnorm} gives the distribution function, \code{qskewnorm} gives the quantile function, and \code{rskewnorm} generates random deviates.
}
\description{
Density, distribution function, quantile function, and random generation for
the skew normal distribution.
}
\details{
This implementation of \code{dskewnorm} allows for automatic differentiation with \code{RTMB} while the other functions are imported from the \code{sn} package.
See \code{sn::\link[sn]{dsn}} for more details.
}
\examples{
# alpha is skew parameter
x <- rskewnorm(1, alpha = 1)
d <- dskewnorm(x, alpha = 1)
p <- pskewnorm(x, alpha = 1)
q <- qskewnorm(p, alpha = 1)
}
