% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zibinom.R
\name{zibinom}
\alias{zibinom}
\alias{dzibinom}
\alias{pzibinom}
\alias{rzibinom}
\title{Zero-inflated binomial distribution}
\usage{
dzibinom(x, size, prob, zeroprob = 0, log = FALSE)

pzibinom(q, size, prob, zeroprob = 0, lower.tail = TRUE, log.p = FALSE)

rzibinom(n, size, prob, zeroprob = 0)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{size}{number of trials (zero or more).}

\item{prob}{probability of success on each trial.}

\item{zeroprob}{zero-inflation probability between 0 and 1}

\item{log, log.p}{logical; return log-density if TRUE}

\item{lower.tail}{logical; if \code{TRUE}, probabilities are \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{n}{number of random values to return.}
}
\value{
\code{dzibinom} gives the probability mass function, \code{pzibinom} gives the distribution function, and \code{rzibinom} generates random deviates.
}
\description{
Probability mass function, distribution function, and random generation for
the zero-inflated binomial distribution.
}
\details{
This implementation allows for automatic differentiation with \code{RTMB}.
}
\examples{
set.seed(123)
x <- rzibinom(1, size = 10, prob = 0.5, zeroprob = 0.5)
d <- dzibinom(x, size = 10, prob = 0.5, zeroprob = 0.5)
p <- pzibinom(x, size = 10, prob = 0.5, zeroprob = 0.5)
}
