% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Barabasi.R
\name{Barabasi.X_eff}
\alias{Barabasi.X_eff}
\title{Average Nearest-Neighbor Activity}
\usage{
Barabasi.X_eff(M, x)
}
\arguments{
\item{M}{Adjacency matrix of the network that describes the system}

\item{x}{The value of all the nodes of the system}
}
\value{
A numeric value describing the effective state by the system by using the nearest-neighbour activity.
}
\description{
This is the average nearest-neight activity described by Barabasi in his paper 'Universal resilience patterns in complex networks'. It can be used to characterize the effective state of the system.
}
\examples{
\donttest{
   node_file <- system.file("extdata", "IL17.nodes.csv", package = "Rato")
   edge_file <- system.file("extdata", "IL17.edges.csv", package = "Rato")
   g <- Rato::graph.from.csv(node_file, edge_file, sep=",", header=TRUE)
 
   initial_parameters <- function(M){
     initial_params <- list('f' = 1, 'h' = 2, 'B' = 0.1, 'Beta' = Rato::Barabasi.B_eff(M))
     return(initial_params)
   }
   
   update_parameters <- function(params){
     M <- params$M
     params$Beta <- Rato::Barabasi.B_eff(M)
     return(params)
   }
 
   Rato::node.removal.thread( system = Rato::Michaelis.Menten.Fast
                            , M = g$M
                            , x0 = Rato::Barabasi.X_eff(g$M, g$initial_values)
                            , initial_params = initial_parameters
                            , update_params = update_parameters
                            , to.numeric = TRUE)

}
}
