% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Score.R
\name{node.score}
\alias{node.score}
\title{Node score in network dynamics with significance test}
\usage{
node.score(
  system,
  M,
  x0,
  nodes,
  initial_params = list(),
  times = seq(0, 100, 1),
  reduction = mean,
  bootstrap_iterations = 100,
  skip_equal_nodes = TRUE
)
}
\arguments{
\item{system}{A function defining the system's dynamics: `system(time, x, params)`, which returns a list of state deltas `dx`.}

\item{M}{The initial adjacency matrix of the network.}

\item{x0}{Initial conditions of the network's nodes (numeric vector).}

\item{nodes}{Nodes of interest to be removed.}

\item{initial_params}{Either a list of initial parameters or a function of type `f(M) -> list` that takes the adjacency matrix of the network as input and returns the initial parameters of the system.}

\item{times}{A vector of time points for the ODE solver.}

\item{reduction}{A reduction function applied to the ODE solution. The output of this function must be a numeric value. The default is `mean`.}

\item{bootstrap_iterations}{The number of bootstrap iterations to run.}

\item{skip_equal_nodes}{Whether to check if the sampled nodes are equal to the input nodes in the bootstrap method. This should be `TRUE` when nodes contain a single element or when the network is small.}
}
\value{
A list `L` with the following entries:

- \strong{L$score}: The score of the nodes.

- \strong{L$normalized.score}: The normalized score of the nodes.

- \strong{L$p.value}: A p-value associated with the significance of the score.

- \strong{L$normalized.p.value}: A normalized p-value associated with the significance of the score.
}
\description{
This function evaluates the significance of one or more nodes in a network given a system.
It initially tests the dynamics of the network under a healthy state (i.e., without any perturbation).
Then, it removes the specified nodes and runs the ODE again.
The function compares the final state of the network under the perturbation to that of the healthy network to assess the importance of the nodes for network health.
Additionally, it uses bootstrap methods to estimate a p-value associated with this score.
}
\examples{
\donttest{
   node_file <- system.file("extdata", "IL17.nodes.csv", package = "Rato")
   edge_file <- system.file("extdata", "IL17.edges.csv", package = "Rato")

   g <- Rato::graph.from.csv(node_file, edge_file, sep=",", header=TRUE)
   
   
   # Get the raw score of a node in the network
   score <- Rato::node.score(
       Rato::Michaelis.Menten  # Use the Michaelis-Menten equation
     , g$M               # The GRN as an adjacency matrix
     , g$initial_values  # The initial values of the genes
     , g$node_index("ko:K03171") # The gene of interest
     , initial_params = list('f' = 1, 'h'=2, 'B'=0.01) # Parameters of the Michaelis-Menten equation
   )
}
}
