% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence_probs.R
\name{sequence_probs}
\alias{sequence_probs}
\title{Calculation of probabilities for binary sequences}
\usage{
sequence_probs(Xt)
}
\arguments{
\item{Xt}{Representative matrix generated by the genetic algorithm
with \code{\link{iter_matrix}}}
}
\value{
A vector of probabilities for the binary sequences
}
\description{
Calculation of proabilities for binary sequences based on the
final matrix generated by the genetic algorithm
}
\details{
Observation of binary correlated binary data can be expressed as
binary sequences. In the case of two binary variables possible
observations are (0,0), (0,1), (1,0) and (1,1). In general, 2^m
binary sequences are possible, where m is the number of binary
variables. Based on the representative matrix generated by the
genetic algorithm the probability for each binary sequence is
determined.
}
\examples{
### Generation of the representive matrix Xt
X0 <- start_matrix(p = c(0.5, 0.6), k = 1000)
Xt <- iter_matrix(X0, R = diag(2), T = 10000, e.min = 0.00001)$Xt

### Calculation of probabilities for binary sequences
sequence_probs(Xt = Xt)
}
\references{
Kruppa, J., Lepenies, B., & Jung, K. (2018). A genetic algorithm for simulating correlated binary data from biomedical research. \emph{Computers in biology and medicine}, \strong{92}, 1-8. \doi{10.1016/j.compbiomed.2017.10.023}
}
\seealso{
For more information, please refer to the package's documentation and the tutorial: \url{https://software.klausjung-lab.de/}.
}
\author{
Jochen Kruppa, Klaus Jung
}
