% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decorr.R
\name{decorr}
\alias{decorr}
\title{De-correlation}
\usage{
decorr(X, lags, method = 1L, separable = FALSE, M = 1, type = 0)
}
\arguments{
\item{X}{Random Field, numeric matrix, or time series}

\item{lags}{numeric vector containing two integer values: the bandwidths for the row- reps. column-wise autocovariance estimation.
(Up to which lag should the autocovariances be estimated?) Lags must be smaller than the dimensions of X.}

\item{method}{1L: square root of the matrix via \code{\link[robcp:modifChol]{robcp::modifChol()}}, inversion via \code{\link[=solve]{solve()}} \cr
2L: square root and inversion via singular value decomposition \cr
3L: square root via \code{\link[expm:sqrtm]{expm::sqrtm()}}, inversion via \code{\link[=solve]{solve()}}}

\item{separable}{if the autocovariance function is (assumed to be) separable in the two directions of X,
those two autocovariances can be estimated separately and then combined (after square root and inversion) as a Kronecker product.}

\item{M}{numeric vector containing two integer values, only needed for \code{type = 1}, see \code{\link[=autocov]{autocov()}}.}

\item{type}{0: ordinary autocovariance estimation, 1: difference-based autocovariance estimation. See \code{\link[=autocov]{autocov()}}.}
}
\value{
De-correlated random field or time series; same data type and size as input \code{X}.
}
\description{
De-correlates a random field or time series, so that the resulting values can be treated as independent.
}
\details{
The contents of \code{X} are ordered into a vector \eqn{x} column-wise. The autocovariance matrix \eqn{\Sigma} of \eqn{x} is estimated by \code{\link[=autocov]{autocov()}}.
\eqn{\Sigma} is taken the square root of and being inverted using the functions specified in \code{method}. Then
\deqn{y = \Sigma^{-\frac{1}{2}} (x - \bar{x}).}
Then \eqn{y} is ordered back into a matrix \eqn{Y} with the same dimension as \eqn{X}.
}
\examples{
x <- arima.sim(list(ar = 0.4), 200)
y <- decorr(x, 3)
\donttest{
oldpar <- par(mfrow = c(2, 2))
acf(x)
pacf(x)
acf(y)
pacf(y)
par(oldpar) }

X <- genField(c(20, 20), Theta = genTheta(1, 0.4))
Y <- decorr(X, c(2, 2))


}
