% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genField.R
\name{genField}
\alias{genField}
\title{Generate random fields}
\usage{
genField(
  n,
  distr = rnorm,
  type = 0L,
  H = 100,
  Theta = NULL,
  q = NULL,
  param = NULL,
  ...
)
}
\arguments{
\item{n}{dimensions of the requested random field. Numeric vector.}

\item{distr}{function specifying the error distribution.}

\item{type}{change region type (integer or character). See \code{\link{changeRegion}}.}

\item{H}{height of the location shift (numeric value).}

\item{Theta}{matrix specifying the dependency between observations of a 2-dim random field.
Has to be a 2-dim. matrix where there is an odd number of entries in both dimensions.
Explanations are given in \link{genTheta}.}

\item{q}{dependency parameter for the model order of the MA field (integer > 0).}

\item{param}{dependency parameters for the model parameters of the MA field (numeric vector.)
Both \code{q} and \code{param} are ignored if \code{Theta} is supplied.
A dependency matrix is generated using \code{\link{genTheta}}.}

\item{...}{additional arguments for the generation of \code{\link{changeRegion}}.}
}
\value{
The function returns a matrix of dimension \code{n} that has the \code{\link{class}} "RandomField".
}
\description{
Generate random fields on a regular grid. Dependency can be modeled to some extend.
}
\details{
The dependent random field is generated as follows:
Denote with \eqn{(e_{ij})} the error matrix from which the random field \eqn{(Y_{ij})}
(under the hypothesis, i.e. without any location shift) is generated.
}
\examples{
genField(c(50, 50))
genField(c(50, 50), type = 3, Theta = genTheta(1, 0.2))

}
\seealso{
\link{changeRegion}, \link{genTheta}
}
