% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cma.R
\name{cma}
\alias{cma}
\title{Construct CMA Confidence Intervals via Parametric Method}
\usage{
cma(
  data_df,
  object,
  fitted = TRUE,
  alpha = 0.05,
  outcome,
  domain,
  subset = NULL,
  id,
  nboot = NULL
)
}
\arguments{
\item{data_df}{A functional data frame that contains both name and values for
variables including functional outcome, domain (e.g. time) and ID (e.g. subject names)
used to fit the model \code{object}.}

\item{object}{A fitted Function-on-Scalar Regression (FoSR) object
(e.g., from mgcv::gam()/mgcv::bam()).}

\item{fitted}{Logical. Whether to estimate the simultaneous confidence bands
for the fitted mean function or the fitted parameter function
\itemize{
\item \code{TRUE} - Estimate the simultaneous confidence bands
for the fitted mean outcome function.
\item \code{FALSE} - estimate the simultaneous confidence bands
for the fitted parameter function.
}
Default is \code{TRUE}.}

\item{alpha}{Significance level for SCB. Default is 0.05.}

\item{outcome}{A character string specifying the name of the outcome variable
used in the model.}

\item{domain}{A character string specifying the name of the domain variable
(e.g. time) used in the model.}

\item{subset}{An atomic character vector (e.g., c("user = 1", "age = 30"))
specifying the target function for constructing the SCB.
Each element must be of the form \verb{<name> = <value>}, where \verb{<name>} is
the name of a scalar grouping variable and \verb{<value>} is the desired value.
Whitespace is ignored. Binary or categorical character variables should be
transformed into numeric. Factors are not allowed here because if the input
data contains factor variables, they will be automatically expanded into
dummy (indicator) variables when constructing the design matrix, and
the resulting variable names may differ from the original factor names.
Default is \code{NULL}, representing the reference group.}

\item{id}{A character string specifying the name of the ID variable.}

\item{nboot}{An integer specifying the number of bootstrap samples used to
construct the confidence bands. Default is 10,000.}
}
\value{
A list containing:
\item{mu_hat}{Estimated mean function for the group of interest.}
\item{domain}{The domain used.}
\item{se_hat}{Standard errors of the estimated means.}
\item{scb_low}{Lower bound of the simultaneous confidence band.}
\item{scb_up}{Upper bound of the simultaneous confidence band.}
\item{type}{A character description of the output type.}
}
\description{
This function computes Correlation and Multiplicity Adjusted (CMA) confidence bands
for a specified group in a functional outcome regression model
using parameter simulations approach with Gaussian multiplier bootstrap.
}
\examples{
# example using pupil data
if (requireNamespace("mgcv", quietly = TRUE)) {
data(pupil)
\donttest{
pupil_fpca <- prepare_pupil_fpca(pupil)

fosr_mod <- mgcv::bam(percent_change ~ s(seconds, k=30, bs="cr") +
  s(seconds, by = use, k=30, bs = "cr") +
  s(id, by = Phi1, bs="re") +
  s(id, by = Phi2, bs="re")+
  s(id, by = Phi3, bs="re") +
  s(id, by = Phi4, bs="re"),
  method = "fREML", data = pupil_fpca, discrete = TRUE)

results <- cma(pupil_fpca, fosr_mod, fitted = TRUE, outcome = "percent_change",
               domain = "seconds", subset = c("use = 1"), id = "id")
}

mean_mod <- mgcv::gam(percent_change ~ s(seconds, k = 5, bs = "cr") +
s(seconds, by = use, k = 5, bs = "cr"),
data = pupil, method = "REML")

results <- cma(pupil, mean_mod, fitted = TRUE, outcome = "percent_change",
               domain = "seconds", subset = c("use = 1"), id = "id", nboot = 100)
}

}
\references{
Crainiceanu, C. M., Goldsmith, J., Leroux, A., & Cui, E. (2024).
\emph{Functional Data Analysis with R}.
Chapman and Hall/CRC.
}
