#' Normalized Hamming Distance
#'
#' Computes the proportion of mismatches between two binary or factor vectors
#' of equal length.
#'
#' @param beta_star Target vector (true value).
#' @param beta_init Initial/candidate vector.
#'
#' @return Scalar in [0,1] giving the fraction of differing positions.
#'
#' @examples
#' hamming_distance(c(1, 0, 1, 0), c(1, 1, 1, 0))  # 0.25
#'
#' @export
hamming_distance <- function(beta_star, beta_init) {
  if (length(beta_star) != length(beta_init)) {
    stop("Vectors must have the same length")
  }
  sum(beta_star != beta_init) / length(beta_star)
}
