% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutRate.R
\name{mutRate}
\alias{mutRate}
\title{Scalable Mutation-Rate Strategies for Sca-MCMC}
\usage{
mutRate(type = c("ScaI", "ScaII", "ScaIII"), N, L, beta.star, beta0)
}
\arguments{
\item{type}{Character, one of "ScaI", "ScaII", "ScaIII".}

\item{N}{Integer > 1, number of parallel chains.}

\item{L}{Integer > 0, length of the parameter vector.}

\item{beta.star}{Target parameter vector (binary or factor).}

\item{beta0}{Initial parameter vector (same length as beta.star).}
}
\value{
Numeric vector of length 2, r, or N depending on type,
        summing to Q0 and proportional to the chosen strategy.
}
\description{
Computes the mutation-rate vector Q_P according to three scalable
schemes proposed in the reference paper.
}
\examples{
beta.star <- c(1, 0, 1, 1, 0)
beta0 <- c(1, 1, 1, 0, 0)
mutRate("ScaII", N = 8, L = 5, beta.star, beta0)

}
