% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simGamma.R
\name{simGamma}
\alias{simGamma}
\title{Simulate Gamma Dynamic GLM}
\usage{
simGamma(N = 1000L, p = 4L, alpha_gamma = 2)
}
\arguments{
\item{N}{Integer > 1, number of observations.}

\item{p}{Integer > 0, number of predictors.}

\item{alpha_gamma}{Numeric > 0, shape parameter for gamma distribution (default = 2).}
}
\value{
List with components:
\item{X}{N x p design matrix.}
\item{Y}{Numeric vector of length N, gamma distributed observations.}
\item{beta}{True coefficient vector.}
\item{alpha_gamma}{Shape parameter used.}
}
\description{
Generates a dynamic regression dataset for gamma family GLM
where the rate parameter follows a dynamic process.
}
\examples{
set.seed(3)
dat <- simGamma(N = 500, p = 3)
hist(dat$Y, main = "Gamma Data")

}
