% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SLGPclass.R
\docType{class}
\name{SLGP-class}
\alias{SLGP-class}
\alias{SLGP}
\title{The SLGP S4 Class: Spatial Logistic Gaussian Process Model}
\description{
This S4 class represents a Spatial Logistic Gaussian Process (SLGP) model, designed for
modeling conditional or spatially dependent probability distributions. It encapsulates all
necessary components for training, sampling, and prediction, including the basis function
setup, learned coefficients, and fitted hyperparameters.
}
\section{Slots}{

\describe{
\item{\code{formula}}{A \code{formula} specifying the model structure and covariates.}

\item{\code{data}}{A \code{data.frame} containing the observations used to train the model.}

\item{\code{responseName}}{A \code{character} string specifying the name of the response variable.}

\item{\code{covariateName}}{A \code{character} vector specifying the names of the covariates.}

\item{\code{responseRange}}{A \code{numeric} vector of length 2 indicating the lower and upper bounds of the response.}

\item{\code{predictorsRange}}{A \code{list} containing:
\itemize{
\item \code{predictorsLower}: lower bounds of the covariates;
\item \code{predictorsUpper}: upper bounds of the covariates.
}}

\item{\code{method}}{A \code{character} string indicating the training method used: one of \{"MCMC", "MAP", "Laplace", "none"\}.}

\item{\code{p}}{An \code{integer} indicating the number of basis functions used.}

\item{\code{basisFunctionsUsed}}{A \code{character} string specifying the type of basis functions used:
"inducing points", "RFF", "Discrete FF", "filling FF", or "custom cosines".}

\item{\code{opts_BasisFun}}{A \code{list} of additional options used to configure the basis functions.}

\item{\code{BasisFunParam}}{A \code{list} containing the computed parameters of the basis functions,
e.g., Fourier frequencies or interpolation weights.}

\item{\code{coefficients}}{A \code{matrix} of coefficients for the finite-rank Gaussian process.
Each row corresponds to a realization of the latent field:
\eqn{ Z(x, t) = \sum_{i=1}^p \epsilon_i f_i(x, t) }.}

\item{\code{hyperparams}}{A \code{list} of hyperparameters, including:
\itemize{
\item \code{sigma}: numeric signal standard deviation;
\item \code{lengthscale}: a vector of lengthscales for each input dimension.
}}

\item{\code{trend}}{A \code{function} that returns the trend of the transformed GP (not to be estimated).}

\item{\code{logPost}}{A \code{numeric} value representing the (unnormalized) log-posterior of the model.
Currently available only for MAP and Laplace-trained models.}
}}

