% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datamanagement.R
\name{pre_comput_WNN}
\alias{pre_comput_WNN}
\title{pre_comput_WNN: Precompute quantities for SLGP basis evaluation with weighted nearest-neighbors}
\usage{
pre_comput_WNN(
  normalizedData,
  predictorNames,
  responseName,
  nIntegral = 101,
  nDiscret = 101,
  mode = "pdf"
)
}
\arguments{
\item{normalizedData}{Normalized data frame (\eqn{[0,1]}-scaled).}

\item{predictorNames}{Character vector of covariate names.}

\item{responseName}{Name of the response variable.}

\item{nIntegral}{Number of quadrature points for response domain.}

\item{nDiscret}{Number of discretization steps for covariates.}
}
\value{
A list of intermediate quantities:
\itemize{
\item \code{nodes}: all evaluation points in response × covariates grid,
\item \code{indNodesToIntegral}: indices to map nodes to response bins,
\item \code{indSamplesToNodes}: index mapping from samples to grid nodes,
\item \code{weightSamplesToNodes}: interpolation weights using inverse distance.
}
}
\description{
Computes intermediate quantities for evaluating basis functions via
weighted nearest-neighbor (WNN) interpolation on a discretized grid.
}
\keyword{internal}
