% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_expression.R
\name{PrepSCTFindMarkers}
\alias{PrepSCTFindMarkers}
\title{Prepare object to run differential expression on SCT assay with multiple models}
\usage{
PrepSCTFindMarkers(object, assay = "SCT", verbose = TRUE)
}
\arguments{
\item{object}{Seurat object with SCT assays}

\item{assay}{Assay name where for SCT objects are stored; Default is 'SCT'}

\item{verbose}{Print messages and progress}
}
\value{
Returns a Seurat object with recorrected counts and data in the SCT assay.
}
\description{
Given a merged object with multiple SCT models, this function uses minimum
of the median UMI (calculated using the raw UMI counts) of individual objects
to reverse the individual SCT regression model using minimum of median UMI
as the sequencing depth covariate.
The counts slot of the SCT assay is replaced with recorrected counts and
the data slot is replaced with log1p of recorrected counts.
}
\section{Progress Updates with \pkg{progressr}}{

This function uses
\href{https://cran.r-project.org/package=progressr}{\pkg{progressr}} to
render status updates and progress bars. To enable progress updates, wrap
the function call in \code{\link[progressr]{with_progress}} or run
\code{\link[progressr:handlers]{handlers(global = TRUE)}} before running
this function. For more details about \pkg{progressr}, please read
\href{https://progressr.futureverse.org/articles/progressr-01-intro.html}{\code{vignette("progressr-intro")}}
}

\section{Parallelization with \pkg{future}}{

This function uses
\href{https://cran.r-project.org/package=future}{\pkg{future}} to enable
parallelization. Parallelization strategies can be set using
\code{\link[future]{plan}}. Common plans include \dQuote{\code{sequential}}
for non-parallelized processing or \dQuote{\code{multisession}} for parallel
evaluation using multiple \R sessions; for other plans, see the
\dQuote{Implemented evaluation strategies} section of
\code{\link[future:plan]{?future::plan}}. For a more thorough introduction
to \pkg{future}, see
\href{https://future.futureverse.org/articles/future-1-overview.html}{\code{vignette("future-1-overview")}}
}

\examples{
data("pbmc_small")
pbmc_small1 <- SCTransform(object = pbmc_small, variable.features.n = 20, vst.flavor="v1")
pbmc_small2 <- SCTransform(object = pbmc_small, variable.features.n = 20, vst.flavor="v1")
pbmc_merged <- merge(x = pbmc_small1, y = pbmc_small2)
pbmc_merged <- PrepSCTFindMarkers(object = pbmc_merged)
markers <- FindMarkers(
  object = pbmc_merged,
  ident.1 = "0",
  ident.2 = "1",
  assay = "SCT"
)
pbmc_subset <- subset(pbmc_merged, idents = c("0", "1"))
markers_subset <- FindMarkers(
  object = pbmc_subset,
  ident.1 = "0",
  ident.2 = "1",
  assay = "SCT",
  recorrect_umi = FALSE
)

}
\concept{differential_expression}
\concept{future}
