% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sketching.R
\name{ProjectData}
\alias{ProjectData}
\title{Project full data to the sketch assay}
\usage{
ProjectData(
  object,
  assay = "RNA",
  sketched.assay = "sketch",
  sketched.reduction,
  full.reduction,
  dims,
  normalization.method = c("LogNormalize", "SCT"),
  refdata = NULL,
  k.weight = 50,
  umap.model = NULL,
  recompute.neighbors = FALSE,
  recompute.weights = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{object}{A Seurat object.}

\item{assay}{Assay name for the full data. Default is 'RNA'.}

\item{sketched.assay}{Sketched assay name to project onto. Default is 'sketch'.}

\item{sketched.reduction}{Dimensional reduction results of the sketched assay to project onto.}

\item{full.reduction}{Dimensional reduction name for the projected full dataset.}

\item{dims}{Dimensions to include in the projection.}

\item{normalization.method}{Normalization method to use. Can be 'LogNormalize' or 'SCT'.
Default is 'LogNormalize'.}

\item{refdata}{An optional list for label transfer from sketch to full data. Default is NULL.
Similar to refdata in `MapQuery`}

\item{k.weight}{Number of neighbors to consider when weighting labels for transfer. Default is 50.}

\item{umap.model}{An optional pre-computed UMAP model. Default is NULL.}

\item{recompute.neighbors}{Whether to recompute the neighbors for label transfer. Default is FALSE.}

\item{recompute.weights}{Whether to recompute the weights for label transfer. Default is FALSE.}

\item{verbose}{Print progress and diagnostic messages.}
}
\value{
A Seurat object with the full data projected onto the sketched dimensional reduction results.
The projected data are stored in the specified full reduction.
}
\description{
This function allows projection of high-dimensional single-cell RNA expression data from a full dataset
onto the lower-dimensional embedding of the sketch of the dataset.
}
\concept{sketching}
