% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{sm_keyword_network}
\alias{sm_keyword_network}
\title{Create Keyword Co-occurrence Network}
\usage{
sm_keyword_network(
  data,
  keyword_col = "author_keywords",
  separator = "; ",
  min_cooccurrence = 2,
  top_n = 30,
  layout = "fr"
)
}
\arguments{
\item{data}{Data frame containing papers with keyword information.}

\item{keyword_col}{Name of the column containing keywords. Default is
"author_keywords".}

\item{separator}{Character string separating keywords within a cell.
Default is "; " (Scopus format).}

\item{min_cooccurrence}{Minimum number of times keywords must co-occur to
be included in the network. Default is 2.}

\item{top_n}{Number of top keywords (by frequency) to include. If NULL,
includes all keywords meeting min_cooccurrence. Default is 30.}

\item{layout}{Network layout algorithm. Options include "fr"
(Fruchterman-Reingold), "kk" (Kamada-Kawai), "circle". Default is "fr".}
}
\value{
A ggraph/ggplot object displaying the keyword network.
}
\description{
Generates and visualizes a keyword co-occurrence network from author-provided
keywords. Shows which keywords frequently appear together in the same papers.
}
\examples{
\dontrun{
# Requires API data from sm_search_scopus()
papers <- sm_search_scopus(query, max_count = 100)
network_plot <- sm_keyword_network(papers, top_n = 25)
print(network_plot)
}
}
