% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supercell_merge.R
\name{supercell_merge}
\alias{supercell_merge}
\title{Merging independent SuperCell objects}
\usage{
supercell_merge(SCs, fields = c())
}
\arguments{
\item{SCs}{list of SuperCell objects (results of \link{SCimplify} )}

\item{fields}{which additional fields (e.g., metadata) of the the SuperCell objects to keep when merging}
}
\value{
a list with components
\itemize{
  \item membership - assignment of each single cell to a particular metacell
  \item cell.ids - the original ids of single-cells
  \item supercell_size - size of metacells (former super-cells)
  \item gamma -  graining level of the merged object (estimated as an average size of metacells as the independent SuperCell objects might have different graining levels)
  \item N.SC - number of obtained metacells

}
}
\description{
This function merges independent SuperCell objects
}
\examples{
\donttest{
data(cell_lines) # list with GE - gene expression matrix (logcounts), meta - cell meta data
GE <- cell_lines$GE
cell.meta <- cell_lines$meta

cell.idx.HCC827 <- which(cell.meta == "HCC827")
cell.idx.H838   <- which(cell.meta == "H838")

SC.HCC827 <- SCimplify(GE[,cell.idx.HCC827],  # log-normalized gene expression matrix
                gamma = 20, # graining level
                n.var.genes = 1000,
                k.knn = 5, # k for kNN algorithm
                n.pc = 10) # number of principal components to use
SC.HCC827$cell.line <- supercell_assign(
    cell.meta[cell.idx.HCC827],
    supercell_membership = SC.HCC827$membership)

SC.H838 <- SCimplify(GE[,cell.idx.H838],  # log-normalized gene expression matrix
                gamma = 30, # graining level
                n.var.genes = 1000, # number of top var genes to use for the dim reduction
                k.knn = 5, # k for kNN algorithm
                n.pc = 15) # number of proncipal components to use
SC.H838$cell.line <- supercell_assign(
    cell.meta[cell.idx.H838],
    supercell_membership = SC.H838$membership)

SC.merged <- supercell_merge(list(SC.HCC827, SC.H838), fields = c("cell.line"))

# compute metacell gene expression for SC.HCC827
SC.GE.HCC827 <- supercell_GE(GE[, cell.idx.HCC827], groups = SC.HCC827$membership)
# compute metacell gene expression for SC.H838
SC.GE.H838 <- supercell_GE(GE[, cell.idx.H838], groups = SC.H838$membership)
# merge GE matricies
SC.GE.merged <- supercell_mergeGE(list(SC.GE.HCC827, SC.GE.H838))

}
}
