% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plantlinear.R
\name{plant_linear}
\alias{plant_linear}
\title{Interpolate plant properties using the 'linear' method.}
\usage{
plant_linear(doys, values, maxdoy)
}
\arguments{
\item{doys}{Integer vector of dates (days of year).}

\item{values}{Numeric vector of values.}

\item{maxdoy}{Integer length of the year, 366 for leap years, 365 for normal
years.}
}
\value{
A numeric vector of length \code{maxdoy}.
}
\description{
Creates a daily sequence for one year from doy/value pairs.
}
\examples{
doys <- c(110,200,250,280)
values <-  c(0,0.8,1,0)
maxdoy <- 365
plot(plant_linear(doys = doys, values = values, maxdoy = 365))
}
