% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Alpha_diversity_calculator.R
\name{Alpha_diversity_calculator}
\alias{Alpha_diversity_calculator}
\title{Calculate alpha diversity based on tax summary object}
\usage{
Alpha_diversity_calculator(taxobj, taxlevel, prefix = "")
}
\arguments{
\item{taxobj}{Configured tax summary objects.See in \code{\link{object_config}}.}

\item{taxlevel}{taxonomy levels used for visualization.Must be one of c("Domain","Phylum","Class","Order","Family","Genus","Species","Base").}

\item{prefix}{A character string as prefix of diversity index. Default:""}
}
\value{
'Alpha_diversity_calculator' returns alpha-diversity of each sample in format of column table (dataframe) combined with group information in meta file.
}
\description{
Calculate alpha diversity for each sample
}
\examples{
###data preparation####
data("Two_group")
require(ggplot2)

###analysis####
Alpha_results<- Alpha_diversity_calculator(taxobj = Two_group,taxlevel = "Base")

#Check data frame contained alpha diversity
head(Alpha_results$alphaframe,5)

#Check contained statistics and plot list
names(Alpha_results$plotlist)

#Check statistics for Shannon
Alpha_results$plotlist$Plotobj_Shannon$Statistics

#Extract plot for Shannon
Alpha_results$plotlist$Plotobj_Shannon$Barplot
Alpha_results$plotlist$Plotobj_Shannon$Boxplot
Alpha_results$plotlist$Plotobj_Shannon$Violinplot


}
