% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kruskal_report.R
\name{kruskal_report}
\alias{kruskal_report}
\title{Print Kruskal-Wallis Rank Sum Test report}
\usage{
kruskal_report(
  data,
  treatment_col,
  value_col,
  prior = FALSE,
  comparison_method = "Auto",
  equally_rep = TRUE,
  report = TRUE
)
}
\arguments{
\item{data}{Data frame containing the treatment, value and other information.}

\item{treatment_col}{Numeric indicating where treatment locates (column number) in data.}

\item{value_col}{Numeric indicating where treatment value (column number) in data.}

\item{prior}{logical. Whether conducted prior comparisons.}

\item{comparison_method}{Default would automaticly choose method. Method of multiple comparison,must be one of "SNK" or "Tukey".}

\item{equally_rep}{Logical. Whether all treatments have same number of replication.}

\item{report}{Logical. If print report to console. Default:TRUE}
}
\value{
kruskal_report returns list with

1)basic data description

2)summary of Kruskal-Wallis Rank Sum Test

3)model of multiple comparison

4)difference of multiple comparison

5)letters of multiple comparison, which could be use for visualization.
}
\description{
Print Kruskal-Wallis Rank Sum Test report
}
\examples{
data("cotton",package ="agricolae" )
kruskal_results=kruskal_report(data = cotton,treatment_col =3,value_col = 5)
##here returns NULL because no significance among groups

##to conduct prior comparisons.
kruskal_results=kruskal_report(data = cotton,treatment_col =3,value_col = 5,prior = TRUE)


data("iris")
kruskal_results=kruskal_report(data = iris,treatment_col = 5,value_col = 2)

###extract return##

###basic data description
kruskal_results$basicdata

###summry of Kruskal-Wallis Rank Sum Test
kruskal_results$Kruskal_Wallis_summary

###model of multiple comparision
kruskal_results$muiltiple_comparision_model

###difference of multiple comparision
kruskal_results$comparision_results

###letters of multiple comparision, which could be use for visualization.
kruskal_results$comparison_letters

}
