% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{retrieve_dgm_results}
\alias{retrieve_dgm_results}
\title{Retrieve a Pre-Computed Results of a Method Applied to DGM}
\usage{
retrieve_dgm_results(
  dgm_name,
  method = NULL,
  method_setting = NULL,
  condition_id = NULL,
  repetition_id = NULL
)
}
\arguments{
\item{dgm_name}{Character string specifying the DGM type}

\item{method}{Which method(s) should be returned. The complete results are returned by setting to \code{NULL} (default setting).}

\item{method_setting}{Which method setting(s) should be returned. The complete results are returned by setting to \code{NULL} (default setting).}

\item{condition_id}{which conditions should settings be returned for.}

\item{repetition_id}{Which repetition should be returned. The complete
condition can be returned by setting to either \code{NULL}.}
}
\value{
A data.frame
}
\description{
This function returns a pre-computed results of a given method at a specific
repetition and condition from a dgm. The pre-computed results must be already stored
locally. See \code{\link[=download_dgm_results]{download_dgm_results()}} function for more guidance.
}
\examples{
\donttest{
  # get condition 1, repetition 1 for default method setting
  retrieve_dgm_results("no_bias", condition_id = 1, repetition_id = 1)

  # get condition 1, all repetitions for default method setting
  retrieve_dgm_results("no_bias", condition_id = 1)
}


}
