% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_robust_guess_data_type.R
\name{prep_robust_guess_data_type}
\alias{prep_robust_guess_data_type}
\title{Guess the data type of a vector}
\usage{
prep_robust_guess_data_type(x, k = 50, it = 200)
}
\arguments{
\item{x}{a vector with characters}

\item{k}{\link{numeric} sample size, if less than \verb{floor(length(x) / (it/20)))},
minimum sample size is 1.}

\item{it}{\link{integer} number of iterations when taking samples}
}
\value{
a guess of the data type of \code{x}. An attribute \code{orig_type} is also
attached to give the more detailed guess returned by \code{\link[readr:parse_guess]{readr::guess_parser()}}.
}
\description{
Guess the data type of a vector
}
\section{Algorithm}{
This function takes \code{x} and tries to guess the data type of random subsets of
this vector using \code{\link[readr:parse_guess]{readr::guess_parser()}}. The RNG is initialized with a
constant, so the function stays deterministic. It does such sub-sample based
checks \code{it} times, the majority of the detected datatype determines the
guessed data type.
}

