% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_margins_bin.R
\name{util_margins_bin}
\alias{util_margins_bin}
\title{Utility function to create a margins plot for binary variables}
\usage{
util_margins_bin(
  resp_vars = NULL,
  group_vars = NULL,
  co_vars = NULL,
  threshold_type = NULL,
  threshold_value,
  min_obs_in_subgroup = 5,
  min_obs_in_cat = 5,
  caption = NULL,
  ds1,
  label_col,
  adjusted_hint = "",
  title = "",
  sort_group_var_levels = getOption("dataquieR.acc_margins_sort",
    dataquieR.acc_margins_sort_default),
  include_numbers_in_figures = getOption("dataquieR.acc_margins_num",
    dataquieR.acc_margins_num_default)
)
}
\arguments{
\item{resp_vars}{\link{variable} the name of the binary measurement variable}

\item{group_vars}{\link{variable} the name of the observer, device or
reader variable}

\item{co_vars}{\link{variable list} a vector of covariables, e.g. age and sex for
adjustment}

\item{threshold_type}{\link{enum} empirical | user | none. See \code{acc_margins}.}

\item{threshold_value}{\link{numeric} see \code{acc_margins}}

\item{min_obs_in_subgroup}{\link{integer} from=0. This optional argument specifies
the minimum number of observations that is required to
include a subgroup (level) of the \code{group_var} in the
analysis.}

\item{min_obs_in_cat}{\link{integer} This optional argument specifies the minimum
number of observations that is required to include
a category (level) of the outcome (\code{resp_vars}) in
the analysis.}

\item{caption}{\link{string} a caption for the plot (optional, typically used to
report the coding of cases and control group)}

\item{ds1}{\link{data.frame} the data frame that contains the measurements, after
replacing missing value codes by \code{NA}, excluding
inadmissible values and transforming categorical
variables to factors.}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{adjusted_hint}{\link{character} hint, if adjusted for \code{co_vars}}

\item{title}{\link{character} title for the plot}

\item{sort_group_var_levels}{\link{logical} Should the levels of the grouping
variable be sorted descending by the number of
observations (in the figure)?}

\item{include_numbers_in_figures}{\link{logical} Should the figure report the
number of observations for each level of the grouping
variable?}
}
\value{
A table and a matching plot.
}
\description{
Utility function to create a margins plot for binary variables
}
