% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_numeric.R
\name{vec_cast.double.haven_labelled_defined}
\alias{vec_cast.double.haven_labelled_defined}
\title{Cast defined vector to base numeric (double)}
\usage{
\method{vec_cast.double}{haven_labelled_defined}(x, to, ...)
}
\arguments{
\item{x}{\code{haven_labelled_defined} vector (created by \code{\link[=defined]{defined()}}).}

\item{to}{Target type (must be \code{double()}).}

\item{...}{Ignored; reserved for future use.}
}
\value{
A plain numeric (double) vector.
}
\description{
S3 method for \code{\link[vctrs:vec_cast]{vctrs::vec_cast()}} that converts a
\code{haven_labelled_defined} vector (created by \code{\link[=defined]{defined()}}) to a base
\code{numeric} (double) vector, dropping all semantic metadata.
}
\examples{
x <- defined(c(10, 20), unit = "kg")
vctrs::vec_cast(x, double())
as.numeric(x)
}
