% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display_dV_dx.R
\name{display.dV_dx}
\alias{display.dV_dx}
\title{Display of the volume density of a histogram
\loadmathjax}
\usage{
display.dV_dx(
  histo,
  add = FALSE,
  xgrid = TRUE,
  ygrid = TRUE,
  MC.plot = FALSE,
  MC.col = grey.colors(4, rev = TRUE),
  ...
)
}
\arguments{
\item{histo}{"histo" class object. See \link[espadon]{espadon.class} for class definitions.}

\item{add}{Boolean indicating whether to display the background image.}

\item{xgrid}{Boolean indicating the display of the x grid.}

\item{ygrid}{Boolean indicating the display of the y grid.}

\item{MC.plot}{Boolean. If \code{MC.plot = TRUE}, then \code{display.dV_dx} displays,
if they exist, the quantile zones (Prob = 0, .025, .25, .5, .75, .975, 1)
of variations in volume density.}

\item{MC.col}{Character string, a valid palette with 4 colours corresponding
to 100\%, 95\%, 50\% and median of MC data.}

\item{...}{Additional arguments xlab, ylab, xlim, ylim, main, type, col, lwd, lty and log
managed by the \link[base]{plot} function.}
}
\value{
Returns a plot of the differential histogram included in \code{histo},
with its median, and the quantile areas (0\%-100\%), (2.5\%-97.5\%) and (25\%-75\%)
of the \code{histo$dv_dx} variations, if they exist.
}
\description{
The \code{display.dV_dx} function displays the volume density
of a "histo" class object. Y-units are \mjeqn{cm^3.Gy^{-1}}{ascii}.
}
\examples{
# loading of toy-patient objects (decrease dxyz and increase beam.nb for 
# better result)
step <- 5
patient <- toy.load.patient (modality = c("rtdose", "rtstruct"),
                             roi.name = "gizzard", dxyz = rep (step, 3), 
                             beam.nb = 3)

# Calculation of the differential histogram
H <- histo.from.roi (patient$rtdose[[1]], patient$rtstruct[[1]], 
                     roi.name = "gizzard", breaks = seq (0, 60, by = 2))
display.dV_dx (H, lwd = 2, col = '#00ff00', ylim = c (0,10))
}
\seealso{
\link[espadon]{display.histo}.
}
