% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_names.R
\name{select.names}
\alias{select.names}
\title{Regions of Interest (RoI) indices}
\usage{
select.names(names, roi.name = NULL, roi.sname = NULL, roi.idx = NULL)
}
\arguments{
\item{names}{Words vector}

\item{roi.name}{Vector of words to compare to \code{names}. By default
\code{roi.name = NULL}. See Details}

\item{roi.sname}{Vector of words or parts of words to compare. By default
\code{roi.sname = NULL}. See Details}

\item{roi.idx}{Index vector. By default \code{roi.idx = NULL}. See Details.}
}
\value{
Returns the indices of the elements of the word vector \code{names}
satisfying one or more of the following conditions:
\itemize{
\item ASCII // TRANSLIT transcriptions, without spaces, of \code{names} and
\code{roi.name}, are identical.
\item ASCII // TRANSLIT transcriptions, without spaces of \code{roi.sname}
are identical to part of ASCII // TRANSLIT transcriptions, without spaces of
\code{names}.
\item \code{names} indices belong to the index vector \code{roi.idx}.
}
}
\description{
The select.names function allows you to select words from a
vector of words, according to several criteria, eliminating spaces and case.
}
\details{
If \code{roi.name}, \code{roi.sname}, and \code{roi.idx} are all
\code{NULL}, then all RoI are selected.
}
\examples{
# loading patient objects
names <- c ("Eye left", "EyeR", "OPTICAL nerve L", "opical nervR", "chiasma")

# RoI selection.
select.names (names = names, roi.name = c("eye left", "eye right"))
select.names (names = names, roi.sname = c("eye", "ner"))
select.names (names = names, roi.idx = 4:9)
}
