% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioclims_GRaster.r, R/bioclims_SpatRaster.r
\name{bioclims,GRaster-method}
\alias{bioclims,GRaster-method}
\alias{bioclims}
\alias{bioclims,SpatRaster-method}
\title{BIOCLIM rasters}
\usage{
\S4method{bioclims}{GRaster}(
  ppt,
  tmin,
  tmax,
  tmean = NULL,
  bios = NULL,
  sample = TRUE,
  quarter = 3,
  pptDelta = 1,
  verbose = TRUE
)

\S4method{bioclims}{SpatRaster}(
  ppt,
  tmin,
  tmax,
  tmean = NULL,
  bios = NULL,
  sample = TRUE,
  quarter = 3,
  pptDelta = 1,
  verbose = TRUE
)
}
\arguments{
\item{ppt}{A multi-layered \code{GRaster} or \code{SpatRaster}, representing monthly/weekly/daily precipitation.}

\item{tmin, tmax}{A multi-layered \code{GRaster} or \code{SpatRaster}, representing monthly/weekly/daily minimum and maximum temperature.}

\item{tmean}{Either \code{NULL} (default), or a multi-layered \code{GRaster} or \code{SpatRaster}, representing monthly/weekly/daily average temperature. If \code{NULL}, \code{tmean} will be calculated internally from \code{tmin} and \code{tmax}. Providing these rasters thus saves time if you already have them on hand.}

\item{bios}{Any of:
\itemize{
\item Numeric values: Calculate these BIOCLIM variables. For example, \code{bios = c(1, 12)} calculates BIOCLIMs 1 and 12.
\item \code{NULL} (default): Calculate BIOCLIMs 1 through 19
\item \code{"*"}: Calculate all BIOCLIMs this function can calculate.
\item \code{"+"}: Calculate BIOCLIMs 41 onward.
\item Any combination of the above except \code{NULL} (e.g., \code{c(1, 12, "+")}).
}}

\item{sample}{Logical: If \code{TRUE} (default), BIO4 and 15 are calculated with the sample standard deviation. If \code{FALSE}, then the population standard deviation is used.}

\item{quarter}{Numeric: Length of a "quarter". BIOCLIM variables are typically calculated using monthly-averaged rasters (e.g., precipitation and temperature of January, February, etc.), in which case a "quarter" is 3 months (so the default for \code{quarter} is 3). However, this function can accommodate any set of rasters representing a time series (e.g., 365 for daily rasters), in which case the user can decide what constitutes a "quarter" for calculation of the any BIOCLIMs that use "quarters" in their definitions.}

\item{pptDelta}{Numeric: Value to add to precipitation for calculation of BIO15 (coefficient of variation of precipitation, times 100). Adding a small value avoids division by 0. The default is 1.}

\item{verbose}{Logical: If \code{TRUE} (default), display progress.}
}
\value{
A \code{GRaster} with one or more layers.
}
\description{
The BIOCLIM set of bioclimatic variables were created for modeling species' geographic distributions (Booth et al. 2014). This function can create the "standard" 19 set of variables, plus several more from an "extended" set.

"Classic" set of BIOCLIM variables (Booth et al. 2014):
The units reported below assume that input rasters are in mm (precipitation) and deg C (temperature), and that each raster represents a month (but other time units are allowed, with corresponding changes to the temporal units assumed below).
\itemize{
\item BIO1: Mean annual temperature, calculated using monthly means (deg C)
\item BIO2: Mean diurnal range across months (average of monthly difference between maximum and minimum temperature) (deg C)
\item BIO3: Isothermality (100 * BIO02 / BIO07; unit-less)
\item BIO4: Temperature seasonality (standard deviation across months of average monthly temperature * 100; deg C)
\item BIO5: Maximum temperature of the warmest month (based on maximum temperature; deg C)
\item BIO6: Minimum temperature of the coldest month (based on minimum temperature; deg C)
\item BIO7: Range of annual temperature (BIO05 - BIO06; deg C)
\item BIO8: Temperature of the wettest quarter (based on mean temperature; deg C)
\item BIO9: Temperature of the driest quarter (based on mean temperature; deg C)
\item BIO10: Temperature of the warmest quarter (based on mean temperature; deg C)
\item BIO11: Temperature of the coldest quarter (based on mean temperature; deg C)
\item BIO12: Total annual precipitation (mm)
\item BIO13: Precipitation of the wettest month (mm)
\item BIO14: Precipitation of the driest month (mm)
\item BIO15: Precipitation seasonality (100 * coefficient of variation; unit-less)
\item BIO16: Precipitation of the wettest quarter (mm)
\item BIO17: Precipitation of the driest quarter (mm)
\item BIO18: Precipitation of the warmest quarter (based on mean temperature; mm)
\item BIO19: Precipitation of the coldest quarter (based on mean temperature; mm)
}

"Extended" set of BIOCLIM variables (starts at 41 to avoid conflicts with Kriticos et al. 2014):
\itemize{
\item BIO41: Temperature of the quarter following the coldest quarter (based on mean temperature; deg C)
\item BIO42: Temperature of the quarter following the warmest quarter (based on mean temperature; deg C)
\item BIO43: Precipitation of the quarter following the coldest quarter (based on mean temperature; mm)
\item BIO44: Precipitation of the quarter following the warmest quarter (based on mean temperature; mm)
\item BIO45: Temperature of the quarter following the driest quarter (based on mean temperature; deg C)
\item BIO46: Temperature of the quarter following the wettest quarter (based on mean temperature; deg C)
\item BIO47: Precipitation of the quarter following the driest quarter (based on mean temperature; mm)
\item BIO48: Precipitation of the quarter following the wettest quarter (based on mean temperature; mm)
\item BIO49: Hottest month (based on maximum temperature)
\item BIO50: Coldest month (based on minimum temperature)
\item BIO51: Wettest month
\item BIO52: Driest month
\item BIO53: First month of the warmest quarter (based on mean temperature)
\item BIO54: First month of the coldest quarter (based on mean temperature)
\item BIO55: First month of the wettest quarter
\item BIO56: First month of the driest quarter
\item BIO57: The greatest decrease in temperature from one month to the next (deg C; always >= 0)
\item BIO58: The greatest increase in temperature from one month to the next (deg C; always >= 0)
\item BIO59: The greatest decrease in precipitation from one month to the next (mm; always >= 0)
\item BIO60: The greatest increase in precipitation from one month to the next (mm; always >= 0)
}

By default, "quarter" refers to any consecutive run of three months, not a financial quarter. A quarter can thus include November-December-January, or December-January-February, for example. However, the length of a quarter can be changed using the argument \code{quarter}.

The variables are defined assuming that the input rasters represent monthly values (12 rasters for min/max temperature and precipitation), but you can also use sets of 52 rasters, representing one per week, in which case "quarter" would be a successive run of 3 weeks. You could also attempt 365 rasters, in which case a "quarter" would be a run of 3 successive days.

BIOCLIMs 41 through 44 are added here to capture the "shoulder" seasons (spring and autumn) important in temperature regions. BIOCLIMs 45 through 48 are also included for consistency.

BIOCLIMs 49 through 60 are not bioclimatic variables per se, but useful for assessing the properties of the variables that are defined based on the "-est" month or quarter.
}
\examples{
if (grassStarted()) {

# Setup
library(terra)

# Load rasters with precipitation and min/max temperature
madPpt <- fastData("madPpt")
madTmin <- fastData("madTmin")
madTmax <- fastData("madTmax")

### Classic and extended BIOCLIMs from SpatRasters
bcSR <- bioclims(madPpt, madTmin, madTmax, bios = "*")
bcSR

### BIOCLIMs from GRasters
ppt <- fast(madPpt)
tmin <- fast(madTmin)
tmax <- fast(madTmax)

# For small rasters, takes longer to run compared to SpatRaster version:
bc <- bioclims(ppt, tmin, tmax, bios = c(1, 5, 12))
bc
plot(bc)

}
}
\references{
Booth, T.H., Nix, H.A., Busby, J.R., and Hutchinson, M.F.  2014.  BIOCLIM: The first species distribution modeling package, its early applications and relevance to most current MaxEnt studies. \emph{Diversity and Distributions} 20:1-9 \doi{10.1111/ddi.12144}.

Kriticos, D.J., Jarošik, V., and Otam N.  2014.  Extending the suite of BIOCLIM variables: A proposed registry system and case study using principal components analysis. \emph{Methods in Ecology and Evolution} 5:956-960 \doi{10.1111/2041-210X.12244}.
}
