% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locationCreate.r
\name{.locationCreate,character-method}
\alias{.locationCreate,character-method}
\alias{.locationCreate}
\alias{.locationCreate,SpatRaster-method}
\alias{.locationCreate,SpatVector-method}
\alias{.locationCreate,sf-method}
\title{Connect to "GRASS"}
\usage{
\S4method{.locationCreate}{character}(x, location = NULL, overwrite = FALSE, warn = TRUE)

\S4method{.locationCreate}{SpatRaster}(x, location = NULL, overwrite = FALSE, warn = TRUE)

\S4method{.locationCreate}{SpatVector}(x, location = NULL, overwrite = FALSE, warn = TRUE)

\S4method{.locationCreate}{sf}(x, location = NULL, overwrite = FALSE, warn = TRUE)
}
\arguments{
\item{x}{Any object from which a coordinate reference system (CRS) can be acquired. Ergo, any of:
\itemize{
\item A \code{SpatRaster}, \code{SpatVector}, \code{SpatExtent}, \code{stars}, or \code{sf} object
\item A \code{crs} object (i.e., from \code{\link[sf:st_crs]{sf::st_crs()}}).
\item A CRS (coordinate reference system) WKT string. Some PROJ4 strings \emph{might} work, too.
}}

\item{location}{Character or \code{NULL} (default): Name of the location.}

\item{overwrite}{Logical: If \code{FALSE} (default), and a \strong{GRASS} "coordinate reference frame" with the given name has already been created, then the function will fail. If \code{TRUE}, then the existing \strong{GRASS} "coordinate reference frame" of the same name will be overwritten. \emph{NOTE}: This will \strong{not} remove any \strong{R} objects associated with rasters or vectors in the "location", but they will no longer work because the objects they point to will be overwritten.}

\item{warn}{Logical: If \code{TRUE} (default) and \code{overwrite} is \code{TRUE}, then display a warning.}
}
\value{
A \link{GLocation} object (invisibly).
}
\description{
This function initializes a \strong{GRASS} "project" (previously known in \strong{GRASS} as a "location"; see \code{vignette("projects_mapsets", package = "fasterRaster")}). You need to run this function (often just once) before you use most functions in \strong{fasterRaster}. This function is of use to developers, not most users.
}
\keyword{internal}
