% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vRecat.r
\name{.vRecat}
\alias{.vRecat}
\title{Re-make vector "category" (cat) values}
\usage{
.vRecat(x, gtype, cats = NULL)
}
\arguments{
\item{x}{A \code{GVector} or the \code{\link[=sources]{sources()}} name of a vector in \strong{GRASS}.}

\item{gtype}{Character: Type of vector features in \strong{GRASS} format (i.e., either \code{point}, \code{line}, or \code{area}). See \code{\link[=geomtype]{geomtype()}}.}

\item{cats}{\code{NULL} (default) or \code{integer} or \code{character} vector: Category values of the \strong{GRASS} vector. Supplying these can speed the re-assignment of categories. The values of \code{cats} is \emph{not} used as the new category values. Rather, they will be used to indicate which geometries belong to the same multi-part feature.}
}
\value{
The \code{\link[=sources]{sources()}} name of a vector.
}
\description{
Each geometry in a \strong{GRASS} vector has a "category" number (abbreviated "cat" in output and modules). Geometries can have the same or different numbers, but for functions to work as intended, they often need to have sequential category values, starting at 1, with no skips between integers. This function reconstitutes the category values of a vector in \strong{GRASS} so they being with 1 and have no skips. \strong{This function is mostly of use to developers.}
}
\seealso{
\code{\link[=.vIncrementCats]{.vIncrementCats()}}, \code{\link[=.vCats]{.vCats()}}
}
\keyword{internal}
