% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_loops.R
\name{draw_loops}
\alias{draw_loops}
\title{Draw Self-loop Arrows on a ggplot Object}
\usage{
draw_loops(p, loops_data, zoom_level = 1)
}
\arguments{
\item{p}{A ggplot object to which the self-loop arrows will be added.}

\item{loops_data}{A data frame containing information about the self-loop arrows. The expected columns include:
\itemize{
  \item \code{x_center}, \code{y_center}: Center coordinates of the loop.
  \item \code{radius}: Radius of the loop.
  \item \code{color}: Color of the loop (hexadecimal color code).
  \item \code{width}: Width of the loop line (numeric).
  \item \code{alpha}: Transparency of the loop line (numeric, 0 to 1).
  \item \code{arrow_type}: Type of arrow (\code{"closed"} or \code{"open"}).
  \item \code{arrow_size}: Size of the arrowhead.
  \item \code{gap_size}: Size of the gap in the loop, specified as a fraction of the full circle (numeric, 0 to 1).
  \item \code{loop_width}, \code{loop_height}: Width and height scaling factors for the loop.
  \item \code{orientation}: Rotation angle of the loop in degrees.
  \item \code{two_way}: Logical, whether the loop is bidirectional (adds arrows at both ends).
}}

\item{zoom_level}{Numeric. Adjusts the size of line widths and arrowheads relative to the plot. Default is \code{1}.}
}
\value{
A ggplot object with the specified self-loop arrows added.
}
\description{
This function overlays self-loop arrows to a ggplot object based on data describing their positions, sizes, orientations, and styles. Self-loop arrows can be drawn in one direction or bidirectionally with customizable parameters such as color, width, and arrow type. The data can come from a CSV file generated by the ggsem Shiny app or custom input.
}
\examples{
library(ggplot2)

loops_data <- data.frame(
x_center = -5, y_center = 5, radius = 2, color = '#000000', width = 1,
alpha = 1, arrow_type = 'closed', arrow_size = 0.1, gap_size = 0.2,
loop_width = 5, loop_height = 5, orientation = 0,
two_way = FALSE, locked = FALSE
)

p <- ggplot()

draw_loops(p, loops_data, zoom_level = 1.2)
}
