% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noaatlas.R
\name{get_noaatlas_interactively}
\alias{get_noaatlas_interactively}
\title{Get National Oceanic and Atmospheric Administration (NOAA) Atlas 14 Interactively}
\usage{
get_noaatlas_interactively(
  map = NULL,
  ns = "noaatlas-ui",
  viewer = shiny::paneViewer(),
  title = "NOAA Atlas 14"
)
}
\arguments{
\item{map}{A background leaflet or mapview map to be used for editing. If NULL a blank mapview canvas will be provided.}

\item{ns}{\code{string} name for the Shiny \code{namespace} to use.  The \code{ns}
is unlikely to require a change.}

\item{viewer}{\code{function} for the viewer.  See Shiny \code{\link[shiny]{viewer}}.
NOTE: when using \code{browserViewer(browser = getOption("browser"))} to
open the app in the default browser, the browser window will automatically
close when closing the app (by pressing "done" or "cancel") in most browsers.
Firefox is an exception. See Details for instructions on how to enable this
behaviour in Firefox.}

\item{title}{\code{string} to customize the title of the UI window.  The default
is "NOAA Atlas 14".}
}
\value{
A data.frame.
}
\description{
This function uses the National Oceanic and Atmospheric Administration (NOAA) Atlas 14 API to allow the user to visually
select a location (point) to get numerous precipitation-frequency statistics.
}
\examples{

if(interactive()){
noaatlas_data <- get_noaatlas_interactively()
}
}
