/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "H5TSmodule.h" 

#include "H5private.h"  
#include "H5Eprivate.h" 
#include "H5TSpkg.h"    

#ifdef H5_HAVE_THREADSAFE_API

H5TS_api_info_t H5TS_api_info_p;

herr_t
H5TSmutex_acquire(unsigned lock_count, bool *acquired)
{
    herr_t ret_value = SUCCEED;

    FUNC_ENTER_API_NAMECHECK_ONLY

    
    if (H5_UNLIKELY(H5TS__api_mutex_acquire(lock_count, acquired) < 0))
        HGOTO_DONE(FAIL);

done:
    FUNC_LEAVE_API_NAMECHECK_ONLY(ret_value)
} 

herr_t
H5TSmutex_get_attempt_count(unsigned *count)
{
    herr_t ret_value = SUCCEED;

    FUNC_ENTER_API_NAMECHECK_ONLY

    *count = H5TS_atomic_load_uint(&H5TS_api_info_p.attempt_lock_count);

    FUNC_LEAVE_API_NAMECHECK_ONLY(ret_value)
} 

herr_t
H5TSmutex_release(unsigned *lock_count)
{
    herr_t ret_value = SUCCEED;

    FUNC_ENTER_API_NAMECHECK_ONLY

    
    *lock_count = 0;
    if (H5_UNLIKELY(H5TS__api_mutex_release(lock_count) < 0))
        ret_value = FAIL;

    FUNC_LEAVE_API_NAMECHECK_ONLY(ret_value)
} 
#endif 
