% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timescales.R
\name{pMCtoC14}
\alias{pMCtoC14}
\title{Calculate C14 ages from pMC values.}
\usage{
pMCtoC14(pMC, er = NULL, roundby = NA, lambda = 8033)
}
\arguments{
\item{pMC}{Reported mean of the pMC.}

\item{er}{Reported error of the pMC.}

\item{roundby}{Amount of decimals required for the output. Defaults to \code{roundby=NA}, no rounding.}

\item{lambda}{The mean-life of radiocarbon (based on Libby half-life of 5568 years)}
}
\value{
Radiocarbon ages from pMC values. If pMC values are above 100\%, the resulting radiocarbon ages will be negative.
}
\description{
Calculate C14 ages from pMC values of radiocarbon dates.
}
\details{
Post-bomb dates are often reported as pMC or percent modern carbon. Since Bacon expects radiocarbon ages,
 this function can be used to calculate radiocarbon ages from pMC values. The reverse function is C14.pMC.
}
\examples{
  pMCtoC14(110, 0.5) # a postbomb date, so with a negative 14C age
  pMCtoC14(80, 0.5) # prebomb dates can also be calculated
  pMCtoC14(.8, 0.005) # throws a warning, use F14C.age instead
}
