% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module_bookmark_manager.R
\name{restoreValue}
\alias{restoreValue}
\title{Restore value from bookmark.}
\usage{
restoreValue(value, default)
}
\arguments{
\item{value}{(\code{character(1)}) name of value to restore}

\item{default}{fallback value}
}
\value{
In an application restored from a server-side bookmark,
the variable specified by \code{value} from the \code{values} environment.
Otherwise \code{default}.
}
\description{
Get value from bookmark or return default.
}
\details{
Bookmarks can store not only inputs but also arbitrary values.
These values are stored by \code{onBookmark} callbacks and restored by \code{onBookmarked} callbacks,
and they are placed in the \code{values} environment in the \code{session$restoreContext} field.
Using \code{teal_data_module} makes it impossible to run the callbacks
because the app becomes ready before modules execute and callbacks are registered.
In those cases the stored values can still be recovered from the \code{session} object directly.

Note that variable names in the \code{values} environment are prefixed with module name space names,
therefore, when using this function in modules, \code{value} must be run through the name space function.
}
\keyword{internal}
