% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_batch_correction_samples}
\alias{plot_batch_correction_samples}
\title{Plot correction samples}
\usage{
plot_batch_correction_samples(fragments_list, selected_sample, xlim = NULL)
}
\arguments{
\item{fragments_list}{A list of fragments_repeats objects containing fragment data. must have trace information.}

\item{selected_sample}{A character vector of batch_sample_id for a subset of samples to plot. Or alternatively supply a number to select batch sample by position in alphabetical order.}

\item{xlim}{the x limits of the plot. A numeric vector of length two.}
}
\value{
plot of batch corrected samples
}
\description{
Plot the overlapping traces of the batch control samples
}
\details{
A plot of the raw signal by bp size or repeats for the batch correction samples.

When plotting the traces before repeat correction, we do not expect the samples to be closely overlapping due to run-to-run variation. After repeat correction, the traces should be basically overlapping.

These plots are made using base R plotting. Sometimes these fail to render in the viewing panes of IDEs (eg you get the error 'Error in \code{plot.new()}: figure margins too large)'. If this happens, try saving the plot as a pdf using traditional approaches (see grDevices::pdf).
}
\examples{

fsa_list <- lapply(cell_line_fsa_list[16:19], function(x) x$clone())

find_ladders(fsa_list, show_progress_bar = FALSE)

fragments_list <- find_fragments(fsa_list, min_bp_size = 300)

test_alleles <- find_alleles(
  fragments_list 
)

add_metadata(
  fragments_list,
  metadata
)


call_repeats(
  fragments_list = fragments_list,
  correction = "batch"
)

# traces of bp size shows traces at different sizes
plot_batch_correction_samples(
  fragments_list,
  selected_sample = "S-21-212", xlim = c(100, 120)
)


}
\seealso{
\code{\link[=call_repeats]{call_repeats()}} for more info on batch correction.
}
