% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vapour_input_geometry.R
\name{vapour_layer_extent}
\alias{vapour_layer_extent}
\title{Read layer extent}
\usage{
vapour_layer_extent(dsource, layer = 0L, sql = "", extent = 0, ...)
}
\arguments{
\item{dsource}{data source name (path to file, connection string, URL)}

\item{layer}{integer of layer to work with, defaults to the first (0) or the name of the layer}

\item{sql}{if not empty this is executed against the data source (layer will be ignored)}

\item{extent}{optional extent (xmin,xmax,ymin,ymax)}

\item{...}{unused}
}
\value{
vector of numeric values xmin,xmax,ymin,ymax
}
\description{
Extent of all features in entire layer, possibly after execution of sql query and
input extent filter.
}
\examples{
file <- "list_locality_postcode_meander_valley.tab"
## A MapInfo TAB file with polygons
mvfile <- system.file(file.path("extdata/tab", file), package="vapour")
vapour_layer_extent(mvfile)
}
\seealso{
vapour_read_extent vapour_layer_info
}
