% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{GEVGF}
\alias{GEVGF}
\title{Generalised extreme value distribution growth factors}
\usage{
GEVGF(lcv, lskew, RP)
}
\arguments{
\item{lcv}{linear coefficient of variation}

\item{lskew}{linear skewness}

\item{RP}{return period}
}
\value{
Generalised extreme value estimated growth factor
}
\description{
Estimated growth factors as a function of return period, with inputs of Lcv & LSkew (linear coefficient of variation & linear skewness)
}
\details{
Growth factors are calculated by the method outlined in the Flood Estimation Handbook, volume 3, 1999.
}
\examples{
# Estimate the 50-year growth factor from Lcv = 0.17 and Lskew = 0.04
GEVGF(0.17, 0.04, RP = 50)

}
\author{
Anthony Hammond
}
