#################################################
# Function for calculating entropy weights.
# Originally from: entropyWtsSanjaydynamic.R
# Dependencies: wtSolver.R
#################################################

#' @title Calculate entropy weights
#' @noRd
entropyWts <- function(d, m, k = NULL, option=3) {
  # 1) pick k if needed
  if (is.null(k)) {
    #k = floor(2 * m / d)
    k=floor(sqrt(m))
  }

  a=log(m)/log(k)
  
  # 2) define the terms vector
  terms = unique(floor(seq(1, d, 1) * k / d))
  zeroIdx = which(terms == 0)
  if (length(zeroIdx) > 0) {
    terms = terms[-zeroIdx]
  }
  # 3) solve for weights, now with 'a' forwarded
  if (length(terms) == 1) {
    wts = 1
  } else {
    wts = wtsolve(terms, d, k, a, option=option)
  }
  list(terms = terms, wts = wts)
}
