% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printFunctions.R
\name{hierCredibility-class}
\alias{hierCredibility-class}
\alias{print.hierCredibility}
\alias{summary.hierCredibility}
\alias{fitted.hierCredibility}
\title{Class "hierCredibility" of fitted hierarchical credibility models}
\usage{
\method{print}{hierCredibility}(x, ...)

\method{summary}{hierCredibility}(object, ...)

\method{fitted}{hierCredibility}(object, ...)
}
\arguments{
\item{x}{an object of class \code{\link{hierCredibility}}}

\item{...}{currently ignored.}

\item{object}{an object of class \code{\link{hierCredibility}}}
}
\value{
The function \code{\link{hierCredibility}} returns an object of class \code{hierCredibility}, which has the following slots:

\item{call}{the matched call}

\item{type}{Whether additive or multiplicative hierarchical credibility model is used.}

\item{Variances}{The estimated variance components. \code{s2} is the estimated variance of the individual contracts,
 \code{tausq} the estimate of \eqn{Var(V[j])} and \code{nusq} is the estimate of \eqn{Var(V[jk])}.}

\item{Means}{The estimated averages at the portfolio level (intercept term \eqn{\mu}), at the first
hierarchical level (\eqn{bar(Y)[\%.\% j \%.\% \%.\%]^z}) and at the second hierarchical level (\eqn{bar(Y)[\%.\% jk \%.\%]}).}

\item{Weights}{The weights at the first hierarchical level \eqn{z[j\%.\%]} and at the second hierarchical level \eqn{w[\%.\%jk\%.\%]}.}

\item{Credibility}{The credibility weights at the first hierarchical level \eqn{q[j\%.\%]} and at the second hierarchical level \eqn{z[jk]}.}

\item{Premiums}{The overall expectation \eqn{widehat(\mu)}, sector expectation \eqn{widehat(V)[j]} and group expectation \eqn{widehat(V)[jk]}.}

\item{Relativity}{The estimated random effects \eqn{widehat(U)[j]} and \eqn{widehat(U)[jk]} of the sector and group, respectively.}

\item{RawResults}{Objects of type \code{data.table} with all intermediate results.}

\item{fitted.values}{the fitted mean values, resulting from the model fit.}
}
\description{
Class "hierCredibility" of fitted hierarchical credibility models
}
\section{{S3 methods}}{

\describe{
 \item{\code{print}:}{Prints the \code{call}, the estimated variance parameters and the unique number of categories
  of the hierarchical MLF. The \code{...} argument is currently ignored. Returns an invisible copy of the original
  object.}
 \item{\code{summary}:}{In addition to the output of the \code{print.hierCredibility} function, the \code{summary} function
  prints the random effect estimates as well. Returns an invisible copy of the original object.}
  \item{\code{fitted}:}{Returns the fitted values.}
}
}

\seealso{
\code{\link{hierCredibility}}
}
