% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trx_df_helpers.R
\name{as_trx_df}
\alias{as_trx_df}
\alias{is_trx_df}
\title{Transaction summary helper functions}
\usage{
as_trx_df(
  x,
  col_trx_amt = "trx_amt",
  col_trx_n = "trx_n",
  col_trx_flag = "trx_flag",
  col_exposure = "exposure",
  col_percent_of = NULL,
  col_percent_of_w_trx = NULL,
  col_trx_amt_sq = "trx_amt_sq",
  start_date = as.Date("1900-01-01"),
  end_date = NULL,
  conf_int = FALSE,
  conf_level = 0.95
)

is_trx_df(x)
}
\arguments{
\item{x}{An object. For \code{as_trx_df()}, \code{x} must be a data frame.}

\item{col_trx_amt}{Optional. Name of the column in \code{x} containing transaction
amounts.}

\item{col_trx_n}{Optional. Name of the column in \code{x} containing transaction
counts.}

\item{col_trx_flag}{Optional. Name of the column in \code{x} containing the number
of exposure records with transactions.}

\item{col_exposure}{Optional. Name of the column in \code{x} containing exposures.}

\item{col_percent_of}{Optional. Name of the column in \code{x} containing a
numeric variable to use in "percent of" calculations.}

\item{col_percent_of_w_trx}{Optional. Name of the column in \code{x} containing a
numeric variable to use in "percent of" calculations with transactions.}

\item{col_trx_amt_sq}{Optional and only required when \code{col_percent_of} is
passed and \code{conf_int} is \code{TRUE}. Name of the column in \code{x} containing squared
transaction amounts.}

\item{start_date}{Experience study start date. Default value = 1900-01-01.}

\item{end_date}{Experience study end date}

\item{conf_int}{If \code{TRUE}, future calls to \code{\link[=summary]{summary()}} will include
confidence intervals around the observed utilization rates and any
\code{percent_of} output columns.}

\item{conf_level}{Confidence level for confidence intervals}
}
\value{
For \code{is_trx_df()}, a length-1 logical vector. For \code{as_trx_df()},
a \code{trx_df} object.
}
\description{
Convert aggregate transaction experience studies to the \code{trx_df} class.
}
\details{
\code{is_trx_df()} will return \code{TRUE} if \code{x} is a \code{trx_df} object.

\code{as_trx_df()} will coerce a data frame to a \code{trx_df} object if that
data frame has the required columns for transaction studies listed below.

\code{as_trx_df()} is most useful for working with aggregate summaries of
experience that were not created by actxps where individual policy
information is not available. After converting the data to the \code{trx_df}
class, \code{\link[=summary]{summary()}} can be used to summarize data by any grouping variables,
and \code{\link[=autoplot]{autoplot()}} and \code{\link[=autotable]{autotable()}} are available for reporting.

At a minimum, the following columns are required:
\itemize{
\item Transaction amounts (\code{trx_amt})
\item Transaction counts (\code{trx_n})
\item The number of exposure records with transactions (\code{trx_flag}). This number
is not necessarily equal to transaction counts. If multiple transactions
are allowed per exposure period, \code{trx_flag} will be less than \code{trx_n}.
\item Exposures (\code{exposure})
}

If transaction amounts should be expressed as a percentage of another
variable (i.e. to calculate utilization rates or actual-to-expected ratios),
additional columns are required:
\itemize{
\item A denominator "percent of" column. For example, the sum of account values.
\item A denominator "percent of" column for exposure records with transactions.
For example, the sum of account values across all records with non-zero
transaction amounts.
}

If confidence intervals are desired and "percent of" columns are passed, an
additional column for the sum of squared transaction amounts (\code{trx_amt_sq})
is also required.

The names in parentheses above are expected column names. If the data
frame passed to \code{as_trx_df()} uses different column names, these can be
specified using the \verb{col_*} arguments.

\code{start_date}, and \code{end_date} are optional arguments that are
only used for printing the resulting \code{trx_df} object.

Unlike \code{\link[=trx_stats]{trx_stats()}}, \code{as_trx_df()} only permits a single transaction type and
a single \code{percent_of} column.
}
\examples{
# convert pre-aggregated experience into a trx_df object
dat <- as_trx_df(agg_sim_dat,
                 col_exposure = "n",
                 col_trx_amt = "wd",
                 col_trx_n = "wd_n",
                 col_trx_flag = "wd_flag",
                 col_percent_of = "av",
                 col_percent_of_w_trx = "av_w_wd",
                 col_trx_amt_sq = "wd_sq",
                 start_date = 2005, end_date = 2019,
                 conf_int = TRUE)
dat
is_trx_df(dat)

# summary by policy year
summary(dat, pol_yr)

}
\seealso{
\code{\link[=trx_stats]{trx_stats()}} for information on how \code{trx_df} objects are typically
created from individual exposure records.
}
